<?php

/**
 * Class that operate on table 'buybilloffer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-01-05 22:09
 */
class BuybillofferMySqlExtDAO extends BuybillofferMySqlDAO {

    public function getAutoIncrementValue($DBName) {
        $sql = 'SELECT `AUTO_INCREMENT`
                FROM  INFORMATION_SCHEMA.TABLES
                WHERE TABLE_SCHEMA = "' . $DBName . '"
                AND   TABLE_NAME   = "buybilloffer" ';

        $sqlQuery = new SqlQuery($sql); //
        return $this->querySingleResult($sqlQuery);
    }

    public function insertEX($buybill) {
        $sql = 'INSERT INTO buybilloffer (buybillSerial, buybilldate, buybillsupplierid, buybilltotaldeptbefor, buybilltotaldeptafter, buybilldiscount, buybilldiscountrype, buybilltotalbill, buybillaftertotalbill, buybilltotalpayed, buybillfinalbill, buybillstoreid, buybillsysdate,comment, userid, conditions, buybillclientname, buybillsaveid, buybilldirectpayment, billnameid,deletedbuyid,controlname,payedtax,costcenterid,currencyId,taxOfDiscountPer,taxOfDiscountVal,buybilladdition,buybilladditiontrype) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybill->buybillSerial);
        $sqlQuery->set($buybill->buybilldate);
        $sqlQuery->setNumber($buybill->buybillsupplierid);
        $sqlQuery->set($buybill->buybilltotaldeptbefor);
        $sqlQuery->set($buybill->buybilltotaldeptafter);
        $sqlQuery->set($buybill->buybilldiscount);
        $sqlQuery->setNumber($buybill->buybilldiscountrype);
        $sqlQuery->set($buybill->buybilltotalbill);
        $sqlQuery->set($buybill->buybillaftertotalbill);
        $sqlQuery->set($buybill->buybilltotalpayed);
        $sqlQuery->set($buybill->buybillfinalbill);
        $sqlQuery->setNumber($buybill->buybillstoreid);
        $sqlQuery->set($buybill->buybillsysdate);
        $sqlQuery->set($buybill->comment);
        $sqlQuery->setNumber($buybill->userid);
        $sqlQuery->setNumber($buybill->conditions);
        $sqlQuery->set($buybill->buybillclientname);
        $sqlQuery->setNumber($buybill->buybillsaveid);
        $sqlQuery->setNumber($buybill->buybilldirectpayment);
        $sqlQuery->setNumber($buybill->billnameid);

        $sqlQuery->setNumber($buybill->deletedbuyid);
        $sqlQuery->set($buybill->controlname);
        $sqlQuery->set($buybill->payedtax);
        $sqlQuery->set($buybill->costcenterid);
        $sqlQuery->set((int) $buybill->currencyId);
        $sqlQuery->setNumber((float) $buybill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $buybill->taxOfDiscountVal);
        $sqlQuery->setNumber((float) $buybill->buybilladdition);
        $sqlQuery->setNumber((int) $buybill->buybilladditiontrype);




        $id = $this->executeInsert($sqlQuery);
        $buybill->buybillid = $id;
        return $id;
    }

    public function queryByDateExt($from, $to, $queryString = '') {
        $sql = 'SELECT buybilloffer.*, supplier.suppliername, store.storeName, user.username,delbyuser.username as delbyusername
		 FROM buybilloffer LEFT JOIN supplier
		 ON buybilloffer.buybillsupplierid = supplier.supplierid JOIN store
		 ON buybilloffer.buybillstoreid = store.storeId
		 LEFT JOIN  user
		 ON user.userid = buybilloffer.userid
                 LEFT JOIN  user as delbyuser
		 ON delbyuser.userid = buybilloffer.delbyuserid

		 WHERE buybilloffer.buybilldate >= "' . $from . '" AND buybilloffer.buybilldate <= "' . $to . '"  ' . $queryString . '
		 ORDER BY buybillid DESC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierId($value, $queryString = '') {
        $sql = 'SELECT buybilloffer.*, supplier.suppliername, store.storeName, user.username,delbyuser.username as delbyusername
		 FROM buybilloffer LEFT JOIN supplier
		 ON buybilloffer.buybillsupplierid = supplier.supplierid JOIN store
		 ON buybilloffer.buybillstoreid = store.storeId
		 LEFT JOIN  user
		 ON user.userid = buybilloffer.userid
                 LEFT JOIN  user as delbyuser
		 ON delbyuser.userid = buybilloffer.delbyuserid
		 WHERE buybillsupplierid = ? ' . $queryString . '
		 ORDER BY buybillid DESC';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySerial($value, $queryString = '') {
        $sql = 'SELECT buybilloffer.*, supplier.suppliername, store.storeName, user.username,delbyuser.username as delbyusername
		 FROM buybilloffer LEFT JOIN supplier
		 ON buybilloffer.buybillsupplierid = supplier.supplierid JOIN store
		 ON buybilloffer.buybillstoreid = store.storeId
		 LEFT JOIN  user
		 ON user.userid = buybilloffer.userid
                 LEFT JOIN  user as delbyuser
		 ON delbyuser.userid = buybilloffer.delbyuserid

		 WHERE buybillSerial = ? ' . $queryString . '
		 ORDER BY buybillid DESC';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function loadExt($id) {
        $sql = 'SELECT buybilloffer.*, supplier.suppliername, store.storeName
		 FROM buybilloffer LEFT JOIN supplier
		 ON buybilloffer.buybillsupplierid = supplier.supplierid JOIN store
		 ON buybilloffer.buybillstoreid = store.storeId
		 WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    public function loadExt2($id, $queryString = '') {
        $sql = 'SELECT buybilloffer.*, supplier.suppliername, store.storeName, user.username,delbyuser.username as delbyusername
		 FROM buybilloffer LEFT JOIN supplier
		 ON buybilloffer.buybillsupplierid = supplier.supplierid JOIN store
		 ON buybilloffer.buybillstoreid = store.storeId
		 LEFT JOIN  user
		 ON user.userid = buybilloffer.userid
                 LEFT JOIN  user as delbyuser
		 ON delbyuser.userid = buybilloffer.delbyuserid

		 WHERE buybillid = ? ' . $queryString . '
		 ORDER BY buybillid DESC';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getList($sqlQuery);
    }

    public function updateOrderSavedBillId($buybillid, $offerId) {
        $sql = 'UPDATE buybilloffer SET orderSavedBillId = ' . $buybillid . ' WHERE buybillid = ' . $offerId;
        $sqlQuery = new SqlQuery($sql);

        return $this->executeUpdate($sqlQuery);
    }

}

?>